<?php

namespace App\Services\Gateway;


class MotionPaySDK
{
	var $pay_config;

	function __construct($pay_config){
		$this->pay_config = $pay_config;
		$this->pay_gateway_new = $this->pay_config['apiurl'].'submit.php?';
	}
	
	
	/**
     * 生成要请求给支付宝的参数数组
     * @param $para_temp 请求前的参数数组
     * @return 要请求的参数数组
     */
	function buildRequestPara($para) {
		//除去待签名参数数组中的空值和签名参数
		$para_filter = array();
		foreach ($para as $key=>$val){
			if($key=="sign" || $key=="sign_type" || $val == "")continue;
			else $para_filter[$key] = $para[$key];
		}
		//对待签名参数数组排序
		ksort($para_filter);
		reset($para_filter);

		//把数组所有元素，按照“参数=参数值”的模式用“&”字符拼接成字符串
		$data = urldecode(http_build_query($para_filter)).$this->pay_config['key'];
		
		//生成签名结果
		$mysign = md5($data);
		//签名结果与签名方式加入请求提交参数组中
		$para_filter['sign'] = $mysign;
		$para_filter['sign_type'] = strtoupper(trim($this->pay_config['sign_type']));

		return $para_filter;
	}

	/**
     * 建立请求，以表单HTML形式构造（默认）
     * @param $para_temp 请求参数数组
     * @param $method 提交方式。两个值可选：post、get
     * @param $button_name 确认按钮显示文字
     * @return 提交表单HTML文本
     */
    function curl_get($url)
    {
    	$ch = curl_init($url);
    	$httpheader[] = 'Accept:*/*';
    	$httpheader[] = 'Accept-Language:zh-CN,zh;q=0.8';
    	$httpheader[] = 'Connection:close';
		$httpheader[] = 'Content-Type: application/json';
    	curl_setopt($ch, CURLOPT_HTTPHEADER, $httpheader);
    	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    	curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Linux; U; Android 4.4.1; zh-cn; R815T Build/JOP40D) AppleWebKit/533.1 (KHTML, like Gecko)Version/4.0 MQQBrowser/4.5 Mobile Safari/533.1');
    	curl_setopt($ch, CURLOPT_FOLLOWLOCATION ,1);
    	curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    	$content = curl_exec($ch);
    	curl_close($ch);
    	return $content;
    }
	function buildRequestForm($para_temp, $return, $method='GET', $button_name='正在跳转') {
		//待请求参数数组
		$para = $this->buildRequestPara($para_temp);
		$arg = '';
		$sHtml = "<form id='motionpaysubmit' name='motionpaysubmit' action='".$this->pay_gateway_new."' method='".$method."'>";
		switch ($return) {
			case 'url':
				foreach ($para as $key=>$val){
					$arg.=$key."=".$val."&";
				}
				//去掉最后一个&字符
				$arg = rtrim($arg,'&');
				$sHtml = $this->pay_gateway_new.$arg;
				break;
			case 'data':
			    foreach ($para as $key=>$val){
					$arg.=$key."=".$val."&";
				}
				//去掉最后一个&字符
				$arg = rtrim($arg,'&');
				$url = $this->pay_gateway_new.$arg;
				$json = $this->curl_get($url);
				$code = json_decode($json, true);
				$sHtml = $code['code_url'];
				break;
			case 'form':
				foreach ($para as $key=>$val){
					$sHtml.= "<input type='hidden' name='".$key."' value='".$val."'/>";
				}
				//submit按钮控件请不要含有name属性
				$sHtml = $sHtml."<input type='submit' value='".$button_name."'></form>";
				$sHtml = $sHtml."<script>document.forms['motionpaysubmit'].submit();</script>";
				break;
			default:
				foreach ($para as $key=>$val){
					$arg.=$key."=".$val."&";
				}
				//去掉最后一个&字符
				$arg = rtrim($arg,'&');
				$sHtml = $this->pay_gateway_new.$arg;
				break;
		}
		return $sHtml;
	}
	 /**
     * 针对notify_url验证消息是否是支付宝发出的合法消息
     * @return 验证结果
     */
	function verifyNotify(){
		if(empty($_GET)) {//判断POST来的数组是否为空
			return false;
		}else {
			//生成签名结果
			$isSign = $this->getSignVeryfy($_GET, $_GET["sign"]);
			//获取支付宝远程服务器ATN结果（验证是否是支付宝发来的消息）
			$responseTxt = 'true';
			//if (! empty($_POST["notify_id"])) {$responseTxt = $this->getResponse($_POST["notify_id"]);}
			
			//验证
			//$responsetTxt的结果不是true，与服务器设置问题、合作身份者ID、notify_id一分钟失效有关
			//isSign的结果不是true，与安全校验码、请求时的参数格式（如：带自定义参数等）、编码格式有关
			if (preg_match("/true$/i",$responseTxt) && $isSign) {
				return true;
			} else {
				return false;
			}
		}
	}
	
	/**
     * 获取返回时的签名验证结果
     * @param $para_temp 通知返回来的参数数组
     * @param $sign 返回的签名结果
     * @return 签名验证结果
     */
	function getSignVeryfy($para, $sign) {
		//除去待签名参数数组中的空值和签名参数
		$para_filter = array();
		foreach ($para as $key=>$val){
			if($key=="sign" || $key=="sign_type" || $val == "")continue;
			else $para_filter[$key] = $para[$key];
		}
		//对待签名参数数组排序
		ksort($para_filter);
		reset($para_filter);
		//把数组所有元素，按照“参数=参数值”的模式用“&”字符拼接成字符串
		$data = urldecode(http_build_query($para_filter));
		$isSgin = false;
		$isSgin = $this->md5Verify($data, $sign, $this->pay_config['key']);

		return $isSgin;
	}
	/**
	* 验证签名
	* @param $prestr 需要签名的字符串
	* @param $sign 签名结果
	* @param $key 私钥
	* return 签名结果
	*/
	function md5Verify($prestr, $sign, $key) {
		$prestr = $prestr . $key;
		$mysgin = md5($prestr);
		if($mysgin == $sign) {
			return true;
		}else {
			return false;
		}
	}	
		
}
?>